(function (exports) {
  'use strict';

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
    }
  }
  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
      writable: false
    });
    return Constructor;
  }
  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    _setPrototypeOf(subClass, superClass);
  }
  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }
  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };
    return _setPrototypeOf(o, p);
  }
  function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }
  function _construct(Parent, args, Class) {
    if (_isNativeReflectConstruct()) {
      _construct = Reflect.construct.bind();
    } else {
      _construct = function _construct(Parent, args, Class) {
        var a = [null];
        a.push.apply(a, args);
        var Constructor = Function.bind.apply(Parent, a);
        var instance = new Constructor();
        if (Class) _setPrototypeOf(instance, Class.prototype);
        return instance;
      };
    }
    return _construct.apply(null, arguments);
  }
  function _isNativeFunction(fn) {
    return Function.toString.call(fn).indexOf("[native code]") !== -1;
  }
  function _wrapNativeSuper(Class) {
    var _cache = typeof Map === "function" ? new Map() : undefined;
    _wrapNativeSuper = function _wrapNativeSuper(Class) {
      if (Class === null || !_isNativeFunction(Class)) return Class;
      if (typeof Class !== "function") {
        throw new TypeError("Super expression must either be null or a function");
      }
      if (typeof _cache !== "undefined") {
        if (_cache.has(Class)) return _cache.get(Class);
        _cache.set(Class, Wrapper);
      }
      function Wrapper() {
        return _construct(Class, arguments, _getPrototypeOf(this).constructor);
      }
      Wrapper.prototype = Object.create(Class.prototype, {
        constructor: {
          value: Wrapper,
          enumerable: false,
          writable: true,
          configurable: true
        }
      });
      return _setPrototypeOf(Wrapper, Class);
    };
    return _wrapNativeSuper(Class);
  }
  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self;
  }
  function _toPrimitive(input, hint) {
    if (typeof input !== "object" || input === null) return input;
    var prim = input[Symbol.toPrimitive];
    if (prim !== undefined) {
      var res = prim.call(input, hint || "default");
      if (typeof res !== "object") return res;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return (hint === "string" ? String : Number)(input);
  }
  function _toPropertyKey(arg) {
    var key = _toPrimitive(arg, "string");
    return typeof key === "symbol" ? key : String(key);
  }

  // https://github.com/dgrammatiko/dark-switch/blob/master/src/index.js
  var darkModeMediaQuery = window.matchMedia('(prefers-color-scheme: dark)');
  var supportsMediaColorScheme = window.matchMedia('(prefers-color-scheme)').media !== 'not all' ? true : false;
  var Switcher = /*#__PURE__*/function (_HTMLElement) {
    _inheritsLoose(Switcher, _HTMLElement);
    function Switcher() {
      var _this;
      _this = _HTMLElement.call(this) || this;
      _this.html = document.documentElement;
      _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
      _this.systemQuery = _this.systemQuery.bind(_assertThisInitialized(_this));
      _this.applyState = _this.applyState.bind(_assertThisInitialized(_this));
      return _this;
    }
    var _proto = Switcher.prototype;
    _proto.connectedCallback = function connectedCallback() {
      this.state = this.html.dataset && this.html.dataset.bsTheme ? this.html.dataset.bsTheme : 'light';
      this.render();
      if (supportsMediaColorScheme && !this.forced) {
        if (darkModeMediaQuery.matches) {
          this.state = 'dark';
          this.applyState();
        }
        darkModeMediaQuery.addListener(this.systemQuery);
      }
    };
    _proto.systemQuery = function systemQuery(event) {
      this.state = event.matches === true ? 'dark' : 'light';
      this.applyState();
    };
    _proto.disconnectedCallback = function disconnectedCallback() {
      if (supportsMediaColorScheme && !this.forced) {
        darkModeMediaQuery.removeListener(this.systemQuery);
      }
      if (this.button) {
        this.button.removeEventListener('click', this.onClick);
      }
    };
    _proto.onClick = function onClick() {
      this.state = this.state === 'light' ? 'dark' : 'light';
      // this.syncValues(this.state).then(() => this.applyState).catch(() => { return; });
      this.applyState();
    };
    _proto.applyState = function applyState() {
      this.button.setAttribute('aria-pressed', this.state == 'dark' ? 'true' : 'false');
      this.html.setAttribute('data-bs-theme', this.state === 'dark' ? 'dark' : 'light');
      window.dispatchEvent(new CustomEvent('joomla:toggle-theme', {
        detail: {
          prefersColorScheme: this.state
        }
      }));
      if (navigator.cookieEnabled) {
        var oneYearFromNow = new Date();
        oneYearFromNow.setFullYear(oneYearFromNow.getFullYear() + 1);
        document.cookie = `mutaPrefersColorScheme=${this.state}; expires=${oneYearFromNow.toGMTString()}`;
      }
    }
    // syncValues(value = 'light') {
    //   const urlBase = Joomla.getOptions('system.paths').baseFull;
    //   return fetch(new URL(`${urlBase}index.php?option=com_users&task=user.setA11ySettings&format=json`), {
    //     method: 'POST',
    //     headers: {
    //       'Content-Type': 'application/json',
    //       'X-CSRF-Token': Joomla.getOptions('csrf.token', ''),
    //     },
    //     body: JSON.stringify({data: {prefersColorScheme: value}}),
    //     redirect: 'follow',
    //   });
    // }
    ;
    _proto.render = function render() {
      if (!this.button) {
        this.button = document.createElement('button');
        this.button.innerText = this.legend;
        this.button.setAttribute('tabindex', 0);
        this.button.setAttribute('aria-pressed', this.state == 'dark' ? 'true' : 'false');
        this.span = document.createElement('span');
        this.span.setAttribute('aria-hidden', 'true');
        this.span.innerText = this.state == 'dark' ? this.on : this.off;
        this.button.appendChild(this.span);
        this.button.addEventListener('click', this.onClick);
        this.appendChild(this.button);
      }
    };
    _createClass(Switcher, [{
      key: "on",
      get: function get() {
        return this.getAttribute('text-on') || 'on';
      }
    }, {
      key: "off",
      get: function get() {
        return this.getAttribute('text-off') || 'off';
      }
    }, {
      key: "legend",
      get: function get() {
        return this.getAttribute('text-legend') || 'dark theme:';
      }
    }, {
      key: "forced",
      get: function get() {
        return this.hasAttribute('forced-theme');
      }
    }]);
    return Switcher;
  }( /*#__PURE__*/_wrapNativeSuper(HTMLElement));
  if (!customElements.get('joomla-theme-switch')) customElements.define('joomla-theme-switch', Switcher);

  exports.Switcher = Switcher;

  return exports;

})({});
